      program ascspg
c
c This program reads an ASCII file created by SPGASC, possible (likely!)
c edited, and writes a new SPG file.  That file may be loaded back into
c the scanner.
c
c A SPG file is the format written by GRE's Data Manager.  There are three
c major sections:
c
c o A five byte header, hex values 02 00 00 00 00
c o Actual data, 26496 bytes
c o A trailing filler of 6272 byes, all hex 00
c
c Written by Ken Plotkin
c            kjp15@cornell.edu
c            January 2001
c
c Distributed as careware.  If you like it, donate some money to a worthwhile
c charity.
c
      character*1 bytes(6),clndat(26496),verbos,chrbnk
      character*12 alpha,alphas,alphat,messag(4),text1,text2
      character*10 actbnk
      character*11 trnkid
      character*8 pldpl
      character*60 infile,outfil,fileup
      character*80 inline
      character*5 cmode(0:6),cmodin,btype(0:6),btypin
      character*23 bnkmod
      character*4 status,buff4
      character*10 threepwood
      dimension ibytes(6),freq0(0:4),step(0:4),pl0(2:9)
      dimension ibyte3(3),ifmap(8)
      logical fexist,vmode
c
      data freq0/29.,108.,137.,380.,806./
      data step/.005,.0125,.005,.0125,.0125/
      data pl0/51.2,76.8,102.4,128.0,153.6,179.2,204.8,230.4/

      data cmode/'AM   ','FM   ','PL   ','DPL  ','LTR  ','MOT  ',
     +   'EDACS'/
      data btype/'Conv ','     ','     ','     ','LTR  ','MOT  ',
     +   'EDACS'/
      data threepwood/'binary'/
c
      if(nargs().gt.1) then
           call getarg(1,infile,istat)
         else
           infile='pro92in.asc'
        endif

      inquire(file=infile,exist=fexist)
      if(.not.fexist) then
           write(*,*) 'Cannot find file '//infile
           stop ' Try again'
        endif
c
      call ucase(infile,fileup)
      l = len_trim(fileup)
      if(fileup(l-3:l).eq.'.SPG') then
           write(*,*)'Oops - you''re trying to convert a spg file.'
           write(*,*)'This program converts an ASCII file to spg.'
           stop ' Use SPGASC to convert spg to ASCII.'
         endif
c
      if(nargs().gt.2) then
           call getarg(2,outfil,istat)
         else
           outfil='pro92out.spg'
        endif
c
c Open the ASCII file, and check for version and whether it's verbose
c mode.  So far, only verbose mode exists.
c
      open(unit=1,file=infile)
      read(1,'(14x,i2,1x,i2,2x,a1)') major,minor,verbos
      if(major.ne.1 .or. minor.gt.3 ) stop
     +'Wrong file version: This program is for ASC V 1.03 or earlier'
      vmode = verbos.eq.'v' .or. verbos.eq.'V'
      vers = float(major) + float(minor)*.01
c
c Top of "Look for next section" loop.  There are five types of such
c sections: Banks, Weather Channels, Preprogrammed Search Bands, Opening
c Message, and Scanner Settings
c
 10   continue
c
      read(1,'(a)') inline
      if(inline(1:6).ne.'******') go to 10
c
      if(inline(8:11).eq.'Bank') then
           read(inline,'(11x,i2,18x,a12,10x,a12)')k,text1,text2
           read(1,*)
c
c     Do the 50 channels for this bank
           do 20, j = 1,50
           if(vmode) then
                read(1,'(i3,22x,a12,3x,f8.4,2x,a5,a8,2x,a4)')
     +           jchan,alpha,freq,cmodin,pldpl,status
              else
                read(1,'(i3,2x,a12,3x,f8.4,2x,a5,a8,2x,a4)')
     +           jchan,alpha,freq,cmodin,pldpl,status
             endif
c
           call chann(freq,cmodin,pldpl,status,ifreq,ibytes)
c
c     Put the results for this channel into CLNDAT

           jj = k*2443 + (j-1)*18
           do ii = 1,6
           clndat(jj+ii) = char(ibytes(ii))
           enddo
           do ii = 1,12
           clndat(jj+6+ii) = alpha(ii:ii)
           enddo
 20        continue
c
c     Bank search data
           read(1,*)
           if(vmode) then
                read(1,'(25x,a12,3x,f8.4,2x,a5,a8,2x,a4)')
     +           alpha,freq,cmodin,pldpl,status
                read(1,'(40x,2f8.4)')freqhi,stepp
              else
                read(1,'(5x,a12,3x,f8.4,2x,a5,a8,2x,a4)')
     +           jchan,alpha,freq,cmodin,pldpl,status
                read(1,'(20x,2f8.4)')freqhi,stepp
             endif
c
           call chann(freq,cmodin,pldpl,status,ifreq,ibytes)
           delfrq = freqhi - freq0(ifreq)

           intfrq = delfrq
           fracf = delfrq - float(intfrq)
           ibyte3(1) = intfrq
           ibyte3(2) = (fracf+.1*step(ifreq))/step(ifreq)
           ibyte3(3) = (stepp+.1*step(ifreq))/step(ifreq)
c     Insert into CLNDAT
           jj = k*2443 + 900
           do ii = 1,6
           clndat(jj+ii) = char(ibytes(ii))
           enddo
           do ii = 1,12
           clndat(jj+6+ii) = alpha(ii:ii)
           enddo
           do ii = 1,3
           clndat(jj+18+ii) = char(ibyte3(ii))
           enddo
c
c     Bank info.
           read(1,*)
           read(1,'(a)')inline
           if(inline(2:5).ne.'Bank')stop 'Bank info line not found'
c     Bank alpha tag
           if(vmode) then
                read(1,'(28x,a12)') alpha
              else
                read(1,'(8x,a12)') alpha
             endif
           jj = k*2443 + 921
           do ii = 1,12
           clndat(jj+ii) = alpha(ii:ii)
           enddo

c     Bank mode and offset.  Flags in bits 0-1, 3-4 of next byte
           if(vmode) then
                read(1,'(28x,a23)') bnkmod
              else
                read(1,'(8x,a23)') bnkmod
             endif
           ii = 0
           if(bnkmod(1:1).eq.'O' .or. bnkmod.eq.'o') ii = ii+2
           if(bnkmod(9:10).eq.'12') ii = ii+4
           if(bnkmod(9:10).eq.'25') ii = ii+8
           if(bnkmod(9:10).eq.'50') ii = ii+12
           jj = k*2443+933
           clndat(jj+1) = char(ii)
c
c     Bank type.  Identify from list.
           if(vmode) then
                read(1,'(28x,a5)') btypin
              else
                read(1,'(8x,a5)') btypin
             endif
           ii = 0
           do i = 0,6
           if(btypin.eq.btype(i)) ibtype = i
           enddo
           jj = k*2443+934
           clndat(jj+1) = char(ibtype)
c
c     Fleet map.  Straight read of data
           if(vmode) then
                read(1,'(27x,8(2x,i2))') ifmap
              else
                read(1,'(7x,8(2x,i2))') ifmap
             endif
           jj = k*2443+935
           do ii = 1,8
           clndat(jj+ii) = char(ifmap(ii))
           enddo
c
c          Search lockouts.  Block of 100 bytes, two bytes per frequency
c          (integer offset, #steps from freq0).  FF FF if no lockout.
c          The ASC file has only those frequencies that are locked out,
c          so we begin by setting the whole block to 0.
c
           jj = k*2443+943
           do ii = 1,100
           clndat(jj+ii) = char(255)
           enddo
c
           read(1,*)
           read(1,'(a)')inline
           if(inline(2:9).ne.'Search l')stop 'Search lockouts not found'
 30        continue
           read(1,'(a)')inline
           if(inline(2:5).eq.'(end') go to 40
           read(inline(1:19),'(i3,6x,f10.4)')kk,frqlck
           delfrq = frqlck - freq0(ifreq)
           intfrq = delfrq
           fracf = delfrq - float(intfrq)
           ibyte3(1) = intfrq
           ibyte3(2) = (fracf+.1*step(ifreq))/step(ifreq)
           jj = k*2443+943 +(kk-1)*2
           clndat(jj+1) = char(ibyte3(1))
           clndat(jj+2) = char(ibyte3(2))
           go to 30
 40        continue
c
c     Talkgroup IDs.
c
           read(1,*)
           read(1,'(a)')inline
           if(inline(2:9).ne.'Talkgrou')stop 'Talkgroup IDs not found'
c
           do kk = 1,100
           if(vers.gt.1.)then
                read(1,'(i4,z3.2,z2.2,6x,a11,6x,a12)')
     +               kdum,ibytes(2),ibytes(1),trnkid,alpha
              else
                read(1,'(i4,z3.2,z2.2,6x,a12)')
     +               kdum,ibytes(2),ibytes(1),alpha
             endif
c
c     LTR ID.  Identify by it being LTR (btype 4)
           if(vers.gt.1. .and. ibtype.eq.4) then
                read(trnkid(1:6),'(i1,i2,i3)') iarea,ireptr,iradio
                ibytes(1) = iradio
                ibytes(2) = ireptr + 32*iarea
c     1-31-00 - Skip mode if text is "Skip"
                if(trnkid(8:11).eq.'Skip') ibytes(2) = ibytes(2) + 128
             endif
c
c     MOT Type 1 ID.  Detect by it being MOT and there being a "-" in trnkid.
           idash = index(trnkid,'-')
           if(vers.gt.1. .and. ibtype.eq.5 .and. idash.gt.0) then
                if(idash.eq.5) read(trnkid,'(i1,i3,1x,i1)')ia,ib,ic
                if(idash.eq.4) read(trnkid,'(i1,i2,1x,i2)')ia,ib,ic
                isiz = ifmap(ia+1)
                call hex1(ival2,isiz,ia,ib,ic)
                ibytes(2) = iand(ival2,z'FF00')/256
                ibytes(1) = iand(ival2,z'00FF')
c     Skip/Scan.  Because this was not in the initial release, make
c     "Scan" the default.
                if(trnkid(8:11).eq.'Skip')
     +                  ibytes(2) = ior(ibytes(2),z'80')
c
             endif
c
c     MOT Type 2 ID.  Detect by it being MOT and not having a dash.  This
c     will also detect blank MOT IDs, which we need to check for Skip status
c     Blank MOT IDs can be type 1 or (as remnants) type 2, so "Skip" can
c     be in either the type 1 or 2 slots.
           if(vers.gt.1. .and. ibtype.eq.5 .and. idash.le.0)then
                read(trnkid(1:5),'(i5)')idval
                idval = idval/16
                write(buff4,'(z4.4)') idval
                if(trnkid(7:10).eq.'Skip') buff4(1:1) = '8'
                if(trnkid(8:11).eq.'Skip') buff4(1:1) = '8'
                read(buff4,'(2z2)')ibytes(2),ibytes(1)
             endif
c
c     EDACS ID
           if(vers.gt.1. .and. ibtype.eq.6) then
                read(trnkid(1:4),'(i4)') idval
                write(buff4,'(z4.4)')idval
                if(trnkid(6:9).eq.'Skip') buff4(1:1) = '8'
                read(buff4,'(2z2)')ibytes(2),ibytes(1)
             endif
c
           jj = k*2443 + 1043 + (kk-1)*14
           clndat(jj+1) = char(ibytes(1))
           clndat(jj+2) = char(ibytes(2))
           do ii = 1,12
           clndat(jj+2+ii) = alpha(ii:ii)
           enddo
           enddo
           go to 10
        endif
c
      if(inline(8:11).eq.'Weat') then
           read(1,*)

c     Weather is Bank 10, with 10 channels.
           k = 10
           do 50, j = 1,10
           if(vmode) then
                read(1,'(i3,22x,a12,3x,f8.4,2x,a5,a8,2x,a4)')
     +           jchan,alpha,freq,cmodin,pldpl,status
              else
                read(1,'(i3,2x,a12,3x,f8.4,2x,a5,a8,2x,a4)')
     +           jchan,alpha,freq,cmodin,pldpl,status
             endif
c
           call chann(freq,cmodin,pldpl,status,ifreq,ibytes)
c
c     Put the results for this channel into CLNDAT

           jj = k*2443 + (j-1)*18
           do ii = 1,6
           clndat(jj+ii) = char(ibytes(ii))
           enddo
           do ii = 1,12
           clndat(jj+6+ii) = alpha(ii:ii)
           enddo
 50        continue

           go to 10
        endif
c
      if(inline(8:11).eq.'Prep') then
           read(1,*)
c     This is Bank 10, with number of channels to be determined
           k = 10
           j = 0
 60        continue
           j = j+1
           if(vmode) then
                read(1,'(i3,22x,a12,3x,f8.4,2x,a5,2f8.4)')
     +           jchan,alpha,freq,cmodin,frequ,stepf
              else
                read(1,'(i3,2x,a12,3x,f8.4,2x,a5,2f8.4)')
     +           jchan,alpha,freq,cmodin,frequ,stepf
             endif
c     This ends with a blank line, which would have 0 frequencies
           if(freq.lt.1.) go to 70

c     Decode the mode
           do i = 0,6
           if(cmodin.eq.cmode(i)) imode = i
           enddo

c     Frequency range
           do i = 0,4
           if(freq.ge.freq0(i)) ifreq = i
           enddo
c     Create Byte 4: low nybble is ifreq, high is imode
c     (Like regular channel Byte 3, with nybbles reversed)
           ibytes(4) = imode*16 + ifreq
c
c     Get whole and fractional part of frequency, relative to freq0
           delfrq = freq - freq0(ifreq)
           intfrq = delfrq
           fracf = delfrq - float(intfrq)
c     Byte 1 is the whole number offset, Byte 2 is the number of steps
c     (Just like regular channel)
           ibytes(1) = intfrq
           ibytes(2) = (fracf+.1*step(ifreq))/step(ifreq)
c
c     Bytes 5 and 6 similar, for the upper frequency
           delfrq = frequ - freq0(ifreq)
           intfrq = delfrq
           fracf = delfrq - float(intfrq)
           ibytes(5) = intfrq
           ibytes(6) = (fracf+.1*step(ifreq))/step(ifreq)
c
c     Byte 3 is number of frequency steps in search step
           ibytes(3) = (stepf + .1*step(ifreq))/step(ifreq)

c     Put into CLNDAT.
           jj = k*2443 + 180 + (j-1)*18
           do ii = 1,6
           clndat(jj+ii) = char(ibytes(ii))
           enddo
           do ii = 1,12
           clndat(jj+6+ii) = alpha(ii:ii)
           enddo
           go to 60
 70        continue
c     Total number.  Insert into proper slot in CLNDAT.
           nprepr = j - 1
           clndat(z'6769'+1) = char(nprepr)
c     If we don't have 100, fill out the rest with null data
           if(nprepr.lt.100) then
                do j = nprepr+1,100
                jj = k*2443 + 180 + (j-1)*18
                clndat(jj+1) = char(0)
                clndat(jj+2) = char(0)
                clndat(jj+3) = char(1)
                clndat(jj+4) = char(16)
                do ii = 5,18
                clndat(jj+ii) = char(0)
                enddo
                enddo
             endif
           go to 10
        endif
c
c Opening screen message
      if(inline(8:11).eq.'Open') then
           read(1,'(/(2x,a12))')messag

           do i = 1,4
           jj = 26410 + (i-1)*12
           do j = 1,12
           clndat(jj+j) = messag(i)(j:j)
           enddo
           enddo

           go to 10
        endif
c
c Scanner settings
      if(inline(8:11).eq.'Scan') then
           read(1,*)
           jj = z'675a'
c     Unknown,default 14.  Read the hex byte and pass it on.
           read(1,'(20x,z2)') ii
           clndat(jj+1) = char(ii)
c     Backlight on time, seconds
           read(1,'(17x,i5)')ltime
           clndat(jj+2) = char(ltime)
c     Scan delay time, msec.  Resolution of 100 msec
           read(1,'(17x,i5)')iscdel
           clndat(jj+3) = char(iscdel/100)
c     Trunk delay time, msec.  Resolution of 100 msec
           read(1,'(17x,i5)')itrdel
           clndat(jj+4) = char(itrdel/100)
c     Unknown default 3F.  Read the hex byte and pass it on.
           read(1,'(20x,z2)') ii
           clndat(jj+5) = char(ii)
c     Minimum scan delay time, resolution of .1 sec
           read(1,'(17x,f5.1)')scnmin
           iscnm = ifix(10.*scnmin + .5)
           clndat(jj+6) = char(iscnm)
c     Display contrast, 9-14
           read(1,'(17x,i5)')icont
           clndat(jj+7) = char(icont)
c     Priority channel (bank, channel)
           read(1,'(17x,i2,i3)') ibnk, ichan
           clndat(jj+8) = char(ichan)
           clndat(jj+9) = char(ibnk)
c     Last search frequency
           read(1,'(13x,3z3)')ii,ii2,ii3
           clndat(jj+10) = char(ii)
           clndat(jj+11) = char(ii2)
           clndat(jj+12) = char(ii3)
c     Priority on/off
           read(1,'(20x,z2)')iprior
           clndat(jj+13) = char(iprior)
c     WX Priority on/off
           read(1,'(20x,z2)')iprior
           clndat(jj+14) = char(iprior)
c     WX Priority channel number
           read(1,'(20x,z2)')iprior
           clndat(jj+15) = char(iprior)
c     Number of preprogrammed search bands; already computed actual.  Skip.
           read(1,*)
c     Keypad tone frequency
           read(1,'(17x,f5.0)') tone
           code = 1000000./tone
           icode = -int(code)
           i1 = iand(icode,z'000000FF')
           i2 = iand(icode,z'0000FF00')/z'100'
           clndat(jj+17) = char(i1)
           clndat(jj+18) = char(i2)
c     Enabled scan banks.  Copy 0-9 over, change anything else to A5
           read(1,'(12x,a10)')actbnk
           do ii = 1,10
           chrbnk = actbnk(ii:ii)
           if(chrbnk.ge.'0' .and. chrbnk.le.'9') then
                clndat(jj+18+ii) = chrbnk
              else
                clndat(jj+18+ii) = char(z'A5')
             endif
           enddo
c     Enabled search banks.  Same deal.
           read(1,'(12x,a10)')actbnk
           do ii = 1,10
           chrbnk = actbnk(ii:ii)
           if(chrbnk.ge.'0' .and. chrbnk.le.'9') then
                clndat(jj+28+ii) = chrbnk
              else
                clndat(jj+28+ii) = char(z'A5')
             endif
           enddo
        endif

c That's it.  Write the data, sandwiched between the header and filler
      open(unit=2,file=outfil,form=threepwood,recl=1)
      write(2)char(2),(char(0),i=1,4)
      write(2) clndat
      write(2) (char(0),i=1,6272)
      close(2)
c
      end

      subroutine chann(freq,cmodin,pldpl,status,ifreq,ibytes)
c
c This routine encodes input frequency, mode, pl/dpl and status
c into the six bytes which will go into the SPG file.  It returns
c these as integer values in IBYTES.  The frequency range, IFREQ,
c is also returned.
c
      character*8 pldpl
      character*5 cmode(0:6),cmodin
      character*4 status
      dimension ibytes(6),freq0(0:4),step(0:4),pl0(2:9)
c
      data freq0/29.,108.,137.,380.,806./
      data step/.005,.0125,.005,.0125,.0125/
      data pl0/51.2,76.8,102.4,128.0,153.6,179.2,204.8,230.4/

      data cmode/'AM   ','FM   ','PL   ','DPL  ','LTR  ','MOT  ',
     +   'EDACS'/
c
c Transmission mode.  Do this first since we'll need it if this is an
c unused channel
      do i = 0,6
      if(cmodin.eq.cmode(i)) imode = i
      enddo
c
c Byte 4 is flags.  Do these here because if it's an unused channel we
c set the data bytes to 00 00 (imode) (byte4) 00 00 and return immediately.
      ibytes(4) = 0
      if(status(1:1).eq.'U') ibytes(4) = ibytes(4) + 8
      if(status(2:2).eq.'D') ibytes(4) = ibytes(4) + 4
      if(status(3:3).eq.'A') ibytes(4) = ibytes(4) + 2
      if(status(4:4).eq.'L') ibytes(4) = ibytes(4) + 1
c
      if(status(1:1).eq.'U') then
           ibytes(1) = 0
           ibytes(2) = 0
           ibytes(3) = imode
           ibytes(5) = 0
           ibytes(6) = 0
           ifreq = 0
           return
        endif
c
c Frequency range
      do i = 0,4
      if(freq.ge.freq0(i)) ifreq = i
      enddo
c Create Byte 3: high nybble is ifreq, low is imode
      ibytes(3) = ifreq*16 + imode
c Get whole and fractional part of frequency, relative to freq0
      delfrq = freq - freq0(ifreq)
      intfrq = delfrq
      fracf = delfrq - float(intfrq)
c Byte 1 is the whole number offset, Byte 2 is the number of steps
c Note the slight upward diddle of the fractional part, to ensure
c we don't lose a step due to rounding.
      ibytes(1) = intfrq
      ibytes(2) = (fracf+.1*step(ifreq))/step(ifreq)
c Bytes 5 and 6 are PL or DPL tones.
c   PL is a base and step offset thing.
c   DPL is a 3-digit octal value.
c   Both bytes are 0 if it's neither PL nor DPL
      ibytes(5) = 0
      ibytes(6) = 0
c
      if(cmodin.eq.'PL   ') then
           read(pldpl,'(f8.1)')plfreq
           ipl = 0
           do i = 2,9
           if(plfreq.ge.pl0(i)) ipl = i
           enddo
           if(ipl.ne.0) then
                plfrac = plfreq - pl0(ipl)
                ibytes(6) = ipl
                ibytes(5) = int(plfrac*10 + .5)
             endif
        endif
      if(cmodin.eq.'DPL') then
           read(pldpl,'(5x,o3)')idpl
           ibytes(6) = idpl/256
           ibytes(5) = iand(idpl,255)
        endif
c
      return
      end
c
      subroutine hex1(ival,isize,ia,ib,ic)
c
c This routine computes the hex value corresponding to Motorola Type 1
c block (ia), fleet (ib) and subfleet (ic), for size Snn, nn = isize.
c
      dimension nsubs(14),incrs(14)
      data nsubs/ 4, 8, 8,16, 4, 8, 4, 4, 4, 8,16,16,16,16/
      data incrs/ 1, 4, 8,32, 2, 2, 4, 8,16,16,16,64,128,256/
c
      nsub = nsubs(isize)
      incr = incrs(isize)
c
      ival = ia*z'200' + ib*incr*nsub + ic*incr + (incr-1)

      return
      end
c
      subroutine ucase(strng,strout)
c Converts a string to all upper case
      character*(*)strng,strout
      character*1 ch
c
      l = len(strng)
      do i = 1,l
      ch = strng(i:i)
      if(ch.ge.'a' .and. ch .le.'z') then
           j = ichar(ch)
           ch = char(j-32)
        endif
      strout(i:i) = ch
      enddo
      return
      end
