      program load92
c
c Loads data from a SPG file into a PRO-92 scanner.
c
c Turbo version - does the upload in 1:15, the same as the clone time.
c
c Written by Ken Plotkin
c            kjp15@cornell.edu
c            December 2000
c            February 2000
c
c Distributed as careware.  If you like it, donate some money to a worthwhile
c charity.
c
      use dflib
      character*1 inchar,datchr,clndat(26551)
      character*1000 datin
      character*60 filnam,fileup
      character*10 arg2
      character*10 threepwood
      logical fexist
c
      threepwood = 'binary'
c
c Do not change the following parameter: it is fixed to the ouput rhythm
c of the scanner.
      iblk = 32
c
      open(unit=7,file='con',carriagecontrol='fortran')
c
c Set up the data start and data end bytes
      do i =1,50
      clndat(i) = char(z'A5')
      enddo
      clndat(51) = char(z'01')
      clndat(52) = char(z'98')
      clndat(53) = char(z'03')
      clndat(54) = char(z'52')
      clndat(26551) = char(z'5A')
c
c Open and read the file containing the data stream.  It gets placed into
c array clndat, which looks just like a clone dump (without a leading CD).
c
      if(nargs().gt.1) call getarg(1,filnam)
c
      call ucase(filnam,fileup)
      l = len_trim(fileup)
      if(fileup(l-3:l).ne.'.SPG') then
           stop 'File to load must be type SPG'
         endif
c
      inquire(file=filnam,exist=fexist)
      if(.not.fexist) then
           write(*,*) 'Cannot find file '//filnam
           stop ' Try again'
        endif
      open(unit=1,file=filnam,form=threepwood,recl=1)
c
c Trim off the first five bytes, then read the data
c
      read(1) (inchar,i=1,5)
      read(1)(clndat(i),i=26550,55,-1)
      close(1)
c
c Default comm port is 1.  /n changes it
      iport = 1
c Inter-iblk delay is normally 20 msec. /snnn changes it
      isnooz = 20
c
c Look for command line switches.  There are two: /n to change the COM
c port to COMn, and /snnn to change the inter-iblk snooze time to nnn msec.
c
      if(nargs().gt.2) then
           do na = 2,nargs()-1
           call getarg(na,arg2)
           if(arg2(1:1).eq.'/'.and.arg2(2:2).ge.'1'
     +   .and. arg2(2:2).le.'3') read(arg2(2:2),'(i1)') iport
           if(arg2(1:2).eq.'/s' .or. arg2(1:2).eq.'/S') then
                l = len_trim(arg2)
                if(l.ge.3) read(arg2(3:l),'(i8)')isnooz
             endif
           enddo
        endif
c
c Start COMiport, 4800,e,8,2
      ierr = sport_connect(iport,16)
      ierr = sport_set_state(iport,4800,2,8,2)
c
c clear RTS (DB9 pin 7) (Set RTS is 3)
      ierr = sport_special_func(iport,4)
c Set DTR (DB9 pin 4) (Clear DTR is 6)
      ierr = sport_special_func(iport,5)
c
      i = 0
      nblok = 0
 10   continue
c
c Put the next character into the output queue.  Quit if we've alredy done
c the last one.
c
      i = i+1
      if(i.gt.26551) go to 20
      datchr = clndat(i)
      ierr = sport_write_data(iport,datchr,1)
      nblok = nblok + 1
c
c Every iblk bytes, or when we reach 54 or 26550 (where parity is changed),
c pause and update the % done message.
c
      if((i.ge.54).and.(nblok.eq.iblk.or.i.eq.54.or.i.ge.26550))then
c
           call sleepqq(isnooz)
c     Extra sleep at #54, the end of the setup bytes
           if(i.eq.54) call sleepqq(40)
c
           write(7,'(''+'',i5,''%'')')i/265
           nblok = 0
        endif
c
c The 54th byte of the data stream put the scanner into data receive
c mode.  Change parity to odd for the data itself.  That involves
c cancelling the IO, then re-setting RTS/DTR
      if(i.eq.54) then
           ierr = sport_cancel_io(iport)
           ierr = sport_set_state(iport,4800,1,8,2)
           ierr = sport_special_func(iport,4)
           ierr = sport_special_func(iport,5)
        endif
c
c Byte 26550 was the last of the data.  Change parity back to even for
c the terminator.
      if(i.eq.26550) then
           ierr = sport_cancel_io(iport)
           ierr = sport_set_state(iport,4800,2,8,2)
           ierr = sport_special_func(iport,4)
           ierr = sport_special_func(iport,5)
        endif
      go to 10
 20   continue
      ierr2 = sport_release(iport)
      write(7,'(a)')'+Done!  Enjoy the upload.'
      end
c
      subroutine ucase(strng,strout)
c Converts a string to all upper case
      character*(*)strng,strout
      character*1 ch
c
      l = len(strng)
      do i = 1,l
      ch = strng(i:i)
      if(ch.ge.'a' .and. ch .le.'z') then
           j = ichar(ch)
           ch = char(j-32)
        endif
      strout(i:i) = ch
      enddo
      return
      end
