      program read92
c
c This program downloads the memory of a PRO-92, and writes a SPG file.
c
c Written by Ken Plotkin
c            kjp15@cornell.edu
c            December 2000
c            February 2000
c
c Distributed as careware.  If you like it, donate some money to a worthwhile
c charity.
c
      use dflib
      character*1 inchar,cd,ch02,ch00
      character*4 cstart
      character*30000 clndat
      character*10 threepwood
      character*60 filnam,file2,fileup
      character*10 arg2
      logical fexist
c
      threepwood = 'binary'
      cd = char(205)
      ch00 = char(0)
      ch02 = char(2)
      cstart = char(z'01')//char(z'98')//char(z'03')//char(z'52')
c
      open(unit=7,file='con',carriagecontrol='fortran')
c
      filnam = 'dump92.spg'
      if(nargs().gt.1) call getarg(1,filnam)
c
      call ucase(filnam,fileup)
      l = len_trim(fileup)
      if(fileup(l-3:l).ne.'.SPG') then
           stop 'Target file must be type SPG'
         endif
c
      inquire(file=filnam,exist=fexist)
      if(fexist)  then
           write(*,*)'File exists.  Return to replace; enter a new'//
     +       ' name to not. ^C to quit.'
           read(*,'(a)')file2
           if(len_trim(file2).gt.0) filnam = file2
        endif
      open(unit=1,file=filnam,form=threepwood,recl=1)
c
c Default comm port is 1.  Can read /n as second argument.
      iport = 1
      if(nargs().gt.2) then
           call getarg(2,arg2)
           if(arg2(1:1).eq.'/'.and.arg2(2:2).ge.'1'
     +   .and. arg2(2:2).le.'3') read(arg2(2:2),'(i1)') iport
        endif
c
c Start COMiport, 4800,e,8,2
c
      ierr = sport_connect(iport,16)
      ierr = sport_set_state(iport,4800,2,8,2)
c Clear RTS: Asserts DB9 pin 7 low
      ierr = sport_special_func(iport,4)
c Set DTR: Asserts DB9 pin 4 high
      ierr = sport_special_func(iport,5)
c
c Read data
c
      nchars = 0
      inoth = 0
c
c Send dump command
c
      ierr = sport_write_data(iport,cd,1)
c
c Catch data as it comes in.  If there are data, tansfer to clndat.  If
c there are no data, wait 1 msec and try again.  If it comes up empty
c 200 times in a row (200 msec), the flow has stopped, and we end it.
c
 10   continue
      ierr = sport_peek_data(iport,ipresn,icount)
      if(ierr.ne.0) write(*,*)'ierr=',ierr
      if(icount.gt.0) then
           ierr = sport_read_data(iport,clndat(nchars+1:26552),ipstat)
           if(ierr.ne.0) write(*,*)'ierr=',ierr
c
           nchars = nchars+ipstat
           write(7,'(''+'',i5,''%'')')nchars/265
           inoth = 0
         else
           call sleepqq(1)
           inoth = inoth+1
        endif
      if(inoth.gt.200 .and.nchars.gt.0) go to 20
      go to 10
 20   continue
      ierr = sport_release(iport)
      write(1)ch02,(ch00,j=1,4)
c
c Look for the start of data string 01 98 03 52
c
      do i = 4,1000
      if(clndat(i-3:i).eq.cstart) then
           idat1 = i+1
           idat2 = i+26496
           exit
        endif
      enddo
cc    write(*,*)
cc    write(*,*)'idat1,idat2,endch',idat1,idat2,
cc   +    ichar(clndat(idat2+1:idat2+1))
cc    write(*,*)
      write(1)(clndat(j:j),j=idat2,idat1,-1)
      write(1)(ch00,j=1,6272)
      close(1)
      nctot = idat2-idat1+1
      if(nctot.eq.26496) then
           write(7,'(a)')'+Done!  Enjoy your data file.'
         else
           write(*,'(a,i7,a)')'Problem: received',nchars,
     +        ' instead of expected 26496.'
        endif
      end
c
      subroutine ucase(strng,strout)
c Converts a string to all upper case
      character*(*)strng,strout
      character*1 ch
c
      l = len(strng)
      do i = 1,l
      ch = strng(i:i)
      if(ch.ge.'a' .and. ch .le.'z') then
           j = ichar(ch)
           ch = char(j-32)
        endif
      strout(i:i) = ch
      enddo
      return
      end
