      program spgasc
c
c This program reads data from a PRO-92 data file (SPG format or actual
c data core) and writes its contents in ASCII format.  That file may be
c user-edited, converted to SPG, and loaded back to the scanner.
c
c A SPG file is the format written by GRE's Data Manager.  There are three
c major sections:
c
c o A five byte header, hex values 02 00 00 00 00
c o Actual data, 26496 bytes
c o A trailing filler of 6272 byes, all hex 00
c
c This program deals with SPG files only.  Earlier versions worked with
c data core only files as well, but once released that feature was never
c used.  We now test for '.SPG' to protect the user.
c
c Written by Ken Plotkin
c            kjp15@cornell.edu
c            January 2001
c
c Distributed as careware.  If you like it, donate some money to a worthwhile
c charity.
c
      character*1 bytes(6),clndat(26496)
      character*12 alpha,alphas,alphat,messag(4)
      character*10 actbnk
      character*11 trnkid
      character*8 pldpl
      character*60 infile,outfil,fileup
      character*5 cmode(0:6),btype(0:6)
      character*23 bnkmod(0:7)
      character*4 status,buff4
      character*10 threepwood
      dimension ibytes(6),freq0(0:4),step(0:4),pl0(2:9)
      dimension ibyte3(3), ifleet(0:7)
      logical fexist
c
      data freq0/29.,108.,137.,380.,806./
      data step/.005,.0125,.005,.0125,.0125/
      data pl0/51.2,76.8,102.4,128.0,153.6,179.2,204.8,230.4/

      data cmode/'AM   ','FM   ','PL   ','DPL  ','LTR  ','MOT  ',
     +   'EDACS'/
      data btype/'Conv ','     ','     ','     ','LTR  ','MOT  ',
     +   'EDACS'/
      data threepwood/'binary'/


      data bnkmod/'Closed  00.0 kHz offset',
     +            'Open    00.0 kHz offset',
     +            'Closed  12.5 kHz offset',
     +            'Open    12.5 kHz offset',
     +            'Closed  25   kHz offset',
     +            'Open    25   kHz offset',
     +            'Closed  50   kHz offset',
     +            'Open    50   kHz offset'/
c
      if(nargs().gt.1) then
           call getarg(1,infile,istat)
         else
           infile='pro92.spg'
        endif
c
      call ucase(infile,fileup)
      l = len_trim(fileup)
      if(fileup(l-3:l) .ne.'.SPG') then
           write(*,*)'Oops - input file must be of type spg.'
           stop ' Check what you''re doing and try again.'
         endif
c
      inquire(file=infile,exist=fexist)
      if(.not.fexist) then
           write(*,*) 'Cannot find file '//infile
           stop ' Try again'
        endif
      if(nargs().gt.2) then
           call getarg(2,outfil,istat)
         else
           outfil='pro92.asc'
        endif

      open(unit=1,file=infile,form=threepwood,recl=1)
c
c Trim off the first 5 bytes.
      read(1)(bytes(i),i=1,5)
      read(1) clndat
      close(1)
      open(unit=1,file=outfil)
      write(1,'(a)')'SPGASC Version 1.03, Verbose format'
      write(1,'(a/)')'Edit this file per the instructions.  Spacing matt
     +ers!'
c
c When picking through the data, JJ is the pointer to the field in
c the data file, counting from 0.  That makes it easy to figure when
c browsing a hex dump.  The data array here begins at 1, so we take data
c beginning at JJ+1.  That makes loops easy, since a 12-byte item will
c be JJ plus 1 to 12.
c
c
c Banks each occupy 2443 bytes.  The first 900 bytes are the channels,
c 18 bytes each.  This is followed by 1543 bytes of search, trunk, etc., data
c
c Weather channels appear after the last bank, in a pretty similar format.
c These are followed by preprogrammed search bands, also pretty similar.
c We have kept those in the sequence as if they were an eleventh bank.
c There are some format differences, which are accounted for by alternate
c code as necessary.  In retrospect, I wish I had kept them separate, rather
c than have all those IFs.  The next line (nchan=50) is one of those details:
c it's the number of channels per bank, and has to be changed to something
c else for the weather/search eleventh bank.
c
      nchan=50
c
      do 30, k = 0,10
      if(k.le.9) then
           do i = 1,12
           alphas(i:i) = clndat(k*2443+906+i)
           alphat(i:i) = clndat(k*2443+921+i)
           enddo

           jj = k*2443 + 933
           ii = ichar(clndat(jj+1))

           jj = k*2443 + 934
           ibtype = ichar(clndat(jj+1))
c
           write(1,'(''****** Bank'',i2,'' ******'',3x,a)')k,
     +       'Tag: '//alphat//'  Type: '//btype(ibtype)//'  Mode: '
     +        //bnkmod(ii/2)(1:6)
c
         else
           write(1,'(''****** Weather Channels ******'')')
        endif
      write(1,*)
c For "Bank 10", we have 7 weather plus 3 unused plus the number of
c preprogrammed search bands
      if(k.eq.10) nchan=ichar(clndat(z'6769'+1)) + 10

      do 20, j = 1,nchan
c
      if(k.eq.10 .and. j.eq.11)
     +   write(1,'(/''****** Preprogrammed Search Bands ******''/)')
c
c Channels are in 18 byte blocks.  The first six are data.  The remaining
c 12 are the alpha tag.
c
      jj = k*2443 + (j-1)*18
      do ii = 1,6
      bytes(ii) = clndat(jj+ii)
      enddo
      do ii = 1,12
      alpha(ii:ii) = clndat(jj+6+ii)
      enddo

      do 10, i = 1,6
c Convert byte input data to integer
      ibytes(i) = ichar(bytes(i))
 10   continue

c Frequency range is high nybble of third byte.  Mode is in the low
c nybble.
      ifreq = ibytes(3)/16
      imode = ibytes(3) - ifreq*16
c
c In Search Bank, range and mode are in fourth byte and the nybbles are
c swapped.
c
c Low nybble of Search Band Byte 3 gives the search step size, in terms of
c the number of frequency steps.
c
      if(k.eq.10 .and. j.ge.11) then
           imode = ibytes(4)/16
           ifreq = iand(z'0F',ibytes(4))
           stepf = step(ifreq)*float(ibytes(3))
        endif
c
c Frequency is base for range plus first byte plus second byte times step
      freq = freq0(ifreq) + float(ibytes(1)) +
     +    float(ibytes(2))*step(ifreq)
c
c If bit 4 of byte 4 is set, the channel is vacant
c
      if(iand(ibytes(4),8).eq.8) freq = 0.
c
c PL and DPL for Banks 0-9; "Bank" 10 is different.
c PL tone: range, as defined by Byte 6, plus 0.1 times byte 5.
c DPL tone is D, plus three digit octal value of bytes 5 & 6 (6 is high)
c
c Default for no tone
      pldpl = '     0.0'
      if(k.le.9) then

           if(imode.eq.2 .and.ibytes(6).ge.2.and.ibytes(6).le.9) then
                plfrq = pl0(ibytes(6)) + float(ibytes(5))*0.1
                write(pldpl,'(f8.1)')plfrq
             endif

           if(imode.eq.3) then
                pldpl = '    D   '
                idpl = 256*ibytes(6) + ibytes(5)
                write(pldpl(6:8),'(o3.3)')idpl
             endif
        endif
c
c "Bank" 10 search banks use Bytes 5 and 6 to define the upper limit
c of each bank.  Role of Byte 3 (frequency range and mode) is as for
c channels, except the nybbles are swapped (it's mode and range.)
c
      if(k.eq.10 .and. j.ge.11 .and.freq.gt.0.) then
           frequ = freq0(ifreq) + float(ibytes(5)) +
     +       float(ibytes(6))*step(ifreq)
         else
           frequ = 0.
        endif
c
c Set up the string showing delay, atten, scan status,
      status = '----'
      if(.not.(k.eq.10 .and. j.ge.11)) then
           if(iand(ibytes(4),8).eq.8) status(1:1) = 'U'
           if(iand(ibytes(4),4).eq.4) status(2:2) = 'D'
           if(iand(ibytes(4),2).eq.2) status(3:3) = 'A'
           if(iand(ibytes(4),1).eq.1) status(4:4) = 'L'
        endif

c
c Write it out.  Search bands use a different format than channels.
      if(k.eq.10 .and. j.ge.11) then
           write(1,'(i3,1x,6z3.2,2x,a14,f10.4,2x,a5,f8.4,f8.4)')
     +       j-11,ibytes,'>'//alpha//'<',freq,cmode(imode),frequ,stepf
         else
           write(1,'(i3,1x,6z3.2,2x,a14,f10.4,2x,a5,a8,2x,a4)')
     +       j-1,ibytes,'>'//alpha//'<',freq,cmode(imode),pldpl,status
        endif
 20   continue
      write(1,*)
c
c The 900 bytes of channel data are followed by bank search info, bank
c alpha tag and trunking info, search lockouts, and talkgroup IDs.
c
      if(k.eq.10) go to 30
c
c Bank search data.  Six data bytes (similar to channels), alpha tag,
c then three more data bytes
      jj = k*2443 + 900

      do ii = 1,6
      ibytes(ii) = ichar(clndat(jj+ii))
      enddo
      do ii = 1,12
      alpha(ii:ii) = clndat(jj+6+ii)
      enddo
      do ii = 1,3
      ibyte3(ii) = ichar(clndat(jj+18+ii))
      enddo
c
c The first six bytes of bank search are interpreted exactly as in
c Channel data
      ifreq = ibytes(3)/16
      imode = ibytes(3) - ifreq*16

      freq = freq0(ifreq) + float(ibytes(1)) +
     +    float(ibytes(2))*step(ifreq)
c
c
      status = '----'
      if(.not.(k.eq.10 .and. j.ge.10)) then
           if(iand(ibytes(4),8).eq.8) status(1:1) = 'U'
           if(iand(ibytes(4),4).eq.4) status(2:2) = 'D'
           if(iand(ibytes(4),2).eq.2) status(3:3) = 'A'
           if(iand(ibytes(4),1).eq.1) status(4:4) = 'L'
        endif


c PL/DPL, as for channels.
      pldpl = '     0.0'
      if(k.le.9) then
           if(imode.eq.2 .and.ibytes(6).ge.2.and.ibytes(6).le.9) then
                plfrq = pl0(ibytes(6)) + float(ibytes(5))*0.1
                write(pldpl,'(f8.1)')plfrq
             endif
           if(imode.eq.3) then
                pldpl = '    D   '
                write(pldpl(6:8),'(z1.1,z2.2)')ibytes(6),ibytes(5)
             endif
        endif
c
c Upper limit of search range is given by first two bytes of 3-byte set.
c Search step is given by third byte of that set
      freqhi = freq0(ifreq) + float(ibyte3(1)) +
     +    float(ibyte3(2))*step(ifreq)
      stepp = step(ifreq)*float(ibyte3(3))
c
      write(1,'(a4,6z3.2,2x,a14,f10.4,2x,a5,a8,2x,a4)')
     +  'Srch',ibytes,'>'//alpha//'<',freq,cmode(imode),pldpl,status
      write(1,'(''End, step''4x,3z3.2,16x,f10.4,f8.4)')
     +   ibyte3,freqhi,stepp
      write(1,*)
c
c Scan bank info
      write(1,'('' Bank'',i2,'' info:'')') k
      jj = k*2443 + 921
c
c 12 character alpha tag
      do ii = 1,12
      alpha(ii:ii) = clndat(jj+ii)
      enddo
      write(1,'(a12,15x,''>'',a12,''<'')') alpha,alpha
c
c Bank mode and Motorola trunking offset
      jj = k*2443 + 933
      ii = ichar(clndat(jj+1))
      write(1,'(z3.2,25x,a,10x,a)')ii,bnkmod(ii/2),'(Mode/Offset)'
c Bank type
      jj = k*2443 + 934
      ibtype = ichar(clndat(jj+1))
      write(1,'(z3.2,25x,a5,28x,a)')ibtype,btype(ibtype),'(Bank type)'
c Fleet map
      jj = k*2443 + 935
      write(1,'(8z3.2,3x,8('' S'',i2.2),a)')(ichar(clndat(jj+ii)),
     +   ii=1,8),(ichar(clndat(jj+ii)),ii=1,8),'  (Fleet map)'
      do ii = 0,7
      ifleet(ii) = ichar(clndat(jj+1+ii))
      enddo
      write(1,*)
c Search lockouts
      write(1,*)'Search lockouts:'
      do kk = 1,50
      jj = k*2443 + 943 + (kk-1)*2
      ibytes(1) = ichar(clndat(jj+1))
      ibytes(2) = ichar(clndat(jj+2))
      if(ibytes(1).ne.255 .and. ibytes(2).ne.255) then
           freq = freq0(ifreq) + float(ibytes(1)) +
     +             float(ibytes(2))*step(ifreq)
           write(1,'(i3,2z3.2,f10.4)')kk,ibytes(1),ibytes(2),freq
        endif
      enddo
      write(1,*)'(end lockouts)'
      write(1,*)
c
c Talkgroup IDs.  Always write 100 fields, regardless of whether any IDs
c are used.
c
c There are four nybbles, the first of which is Scan/Skip and the rest of
c which are the ID.  If an ID slot is unused, display a blank.  If it's
c unused but the Skip nybble is set then display Skip.
c
      write(1,*)'Talkgroup IDs:'
      do kk = 1,100
      trnkid = ' '
      jj = k*2443 + 1043 + (kk-1)*14
      ibytes(1) = ichar(clndat(jj+1))
      ibytes(2) = ichar(clndat(jj+2))
c
c LTR ID
      if(ibtype.eq.4) then
           iradio = ibytes(1)
           ireptr = iand(ibytes(2),31)
           iarea  = iand(ibytes(2),32)/32
           iskip  = iand(ibytes(2),128)/128
           write(trnkid(1:6),'(i6.6)')iradio+1000*ireptr+100000*iarea
           if(iskip.eq.1) then
                trnkid(8:11) = 'Skip'
              else
                trnkid(8:11) = 'Scan'
             endif
c     000000 is no ID.  But allow "Skip" to stand if that's set
           if(trnkid.eq.'000000 Skip') trnkid(1:7) = ' '
           if(trnkid.eq.'000000 Scan') trnkid = ' '
        endif
c
c Motorola trunking. Assemble the two bytes into a 16 bit value, then
c extract the bank and check against the fleet map.  If the size is
c greater than 0, it's Type 1 and we use routine mot1 to extract the
c fleet and sublfleet from the value.
      if(ibtype.eq.5) then
           ival = ibytes(2)*256 + ibytes(1)
           ia = iand(ival,z'e00')/z'200'
           isiz = ifleet(ia)
        endif
c
      if(ibtype.eq.5 .and. isiz.gt.0) then
c
           call mot1(ival,isiz,ib,ic)
c Block size for S12-14 are rounded down to even, fours, eights
           if(isiz.eq.12) ia = iand(ival,z'c00')/z'200'
           if(isiz.eq.13) ia = iand(ival,z'800')/z'200'
           if(isiz.eq.14) ia = 0
c
           if(isiz.eq.1) then
                write(trnkid,'(i1.1,i3.3,''-'',i1.1)')ia,ib,ic
              else
                write(trnkid,'(i1.1,i2.2,''-'',i2.2)')ia,ib,ic
             endif
c     Skip/Scan if high nybble is 8 or 0, respectively
           if(iand(ival,z'8000').eq. 0) then
                trnkid(8:11) = 'Scan'
              else
                trnkid(8:11) = 'Skip'
             endif
c     Update 1-27-01: 0000 is always no ID
           if(ival.eq.0) trnkid = ' '
c     IVAL of 8000 is also no ID, but "Skip" stays
           if(ival.eq.z'8000') trnkid(1:7) = ' '
        endif
c
c Motorola Type 2 ID (Or S00 in a hybrid system).  Write the two bytes
c into 4-character string BUFF4 that will look just like the hex value.
c Then read the lowest 3 characters as hex to get the numeric ID value.
      if(ibtype.eq.5 .and. isiz.eq.0) then
           write(buff4,'(2z2.2)')ibytes(2),ibytes(1)
           read(buff4,'(1x,z3)') idval
           write(trnkid(1:5),'(i5.5)')idval*16
           if(buff4(1:1).eq.'8') then
                trnkid(7:10) = 'Skip'
              else
                trnkid(7:10) = 'Scan'
             endif
c 1-27-01 - Either 8000 or 0000 are no ID, but "Skip" stays if 8000
           if(trnkid.eq.'00000 Skip') trnkid(1:6) = ' '
           if(trnkid.eq.'00000 Scan') trnkid = ' '
c
        endif
c
c EDACS ID
      if(ibtype.eq.6) then
           write(buff4,'(2z2.2)')ibytes(2),ibytes(1)
           read(buff4,'(1x,z3)')idval
           write(trnkid(1:4),'(i4)')idval
           if(buff4(1:1).eq.'8') then
                trnkid(6:9) = 'Skip'
              else
                trnkid(6:9) = 'Scan'
             endif
c     1-27-01  8000 or 0000 are no ID, but "Skip" stays for 8000
           if(buff4.eq.'8000') trnkid(1:5) = ' '
           if(buff4.eq.'0000') trnkid = ' '
        endif
c
      do ii = 1,12
      alpha(ii:ii) = clndat(jj+2+ii)
      enddo
      write(1,'(i4,z3.2,z2.2,5x,a13,4x,a14)')kk,ibytes(2),ibytes(1),
     +  '['//trnkid//']','>'//alpha//'<'
      enddo
      write(1,*)'(end talk IDs)'
      write(1,*)
 30   continue
c
c Message
      write(1,'(a)')'****** Opening screen message ******'
      write(1,*)
      do i = 1,4
      jj = 26410 + (i-1)*12
      do j = 1,12
      messag(i)(j:j) = clndat(jj+j)
      enddo
      enddo
      write(1,'('' >'',a,''<'')')messag
      write(1,*)
      write(1,'(a)')'****** Scanner settings ******'
      write(1,*)
c
      ii = ichar(clndat(z'675a'+1))
      write(1,'(z3.2,17x,z2.2,3x,a)')ii,ii, 'Unknown.  Initialized 14, d
     +efault 00 (hex)'
      ii = ichar(clndat(z'675b'+1))
      write(1,'(z3.2,9x,i10,3x,a)'),ii,ii,'Backlight on time, 1 sec to 2
     +55 sec'
      ii = ichar(clndat(z'675c'+1))
      write(1,'(z3.2,9x,i10,3x,a)'),ii,ii*100,'Scan delay time, 400 msec
     + to 25500 msec'
      ii = ichar(clndat(z'675d'+1))
      write(1,'(z3.2,9x,i10,3x,a)'),ii,ii*100,'Trunk rescan delay time,
     +400 msec to 10000 msec'
      ii = ichar(clndat(z'675e'+1))
      write(1,'(z3.2,17x,z2.2,3x,a)')ii,ii,'Unknown.  Usually 2.55 times
     + trunk delay byte'
      ii = ichar(clndat(z'675f'+1))
      write(1,'(z3.2,f19.1,3x,a)')ii,float(ii)*.1,'Minimum scan delay ti
     +me, 0.4 sec to 25.5 sec'
      ii = ichar(clndat(z'6760'+1))
      write(1,'(z3.2,14x,i5,3x,a)')ii,ii,'Display contrast, 09 (light) t
     +o 14 (blacked out)'
      ii = ichar(clndat(z'6761'+1))
      ii2 = ichar(clndat(z'6762'+1))
c
      write(1,'(2z3.2,11x,i2,i3.2,3x,a)')ii,ii2,ii2,ii,
     +              'Priority channel number'
      ii = ichar(clndat(z'6763'+1))
      ii2 = ichar(clndat(z'6764'+1))
      ii3 = ichar(clndat(z'6765'+1))
      write(1,'(3z3.2,4x,3z3.2,3x,a)')ii,ii2,ii3,ii,ii2,ii3,
     +         'Last search frequency.  Initialized 00 50 00'
      ii = ichar(clndat(z'6766'+1))
      write(1,'(z3.2,17x,z2.2,3x,a)')ii,ii,'Priority: 01 = on, 00 = off'
      ii = ichar(clndat(z'6767'+1))
      write(1,'(z3.2,17x,z2.2,3x,a)')ii,ii,
     +       'Unknown byte.  Initialized 00'
      ii = ichar(clndat(z'6768'+1))
      write(1,'(z3.2,17x,i2.2,3x,a)')ii,ii,
     +  'Unknown byte.  Initialized 00'
      ii = ichar(clndat(z'6769'+1))
      write(1,'(z3.2,i19,3x,a)'),ii,ii,'Number of preprogrammed search b
     +ands (100 max)'
      ii = ichar(clndat(z'676a'+1))
      ii2 = ichar(clndat(z'676b'+1))
      code = float(ii2*256 + ii)
      tonfrq = 1000000./(65536.-code)
      itone = ifix(tonfrq+.3)
      write(1,'(2z3.2,10x,i6,3x,a)')ii,ii2,itone,'Keypad tone frequency,
     + 300 Hz to 3000 Hz'

      do i=1,10
      actbnk(i:i) = clndat(z'676c'+i)
      if(actbnk(i:i).lt.'0' .or. actbnk(i:i).gt.'9') actbnk(i:i) = '-'
      enddo

      write(1,'(10a1,2x,a10,3x,a)') (clndat(z'676c'+i),i=1,10),actbnk,
     +     'Enabled scan banks'

      do i=1,10
      actbnk(i:i) = clndat(z'6776'+i)
      if(actbnk(i:i).lt.'0' .or. actbnk(i:i).gt.'9') actbnk(i:i) = '-'
      enddo

      write(1,'(10a1,2x,a10,3x,a)') (clndat(z'6776'+i),i=1,10),actbnk,
     +     'Active search banks'
c
      end
c
      subroutine mot1(ival,isize,ib,ic)
c
c This routine extracts the fleet (ib) and subfleet(ic) from code ival,
c for fleet size isize.  Block (which would be ia) is not extracted here;
c it had to have been extracted prior to calling this routine so that
c the appropriate value of isize could be determined from the fleet map.
c
c All ISIZEs are covered
c
      dimension nsubs(14),incrs(14)
      data nsubs/ 4, 8, 8,16, 4, 8, 4, 4, 4, 8,16,16,16,16/
      data incrs/ 1, 4, 8,32, 2, 2, 4, 8,16,16,16,64,128,256/
c
      nsub = nsubs(isize)
      incr = incrs(isize)
c
      jsubc = incr-1
      maskc = incr*nsub-1
      maskb = z'1ff' - maskc
      idivc = incr
      idivb = incr*nsub

      if(isize.le.11) then
           ib = iand(ival,maskb)/idivb
         else
           ib = 0
        endif
      ic = iand(ival-jsubc,maskc)/idivc
      return
      end
c
      subroutine ucase(strng,strout)
c Convert a string to upper case
      character*(*)strng,strout
      character*1 ch
c
      l = len(strng)
      do i = 1,l
      ch = strng(i:i)
      if(ch.ge.'a' .and. ch .le.'z') then
           j = ichar(ch)
           ch = char(j-32)
        endif
      strout(i:i) = ch
      enddo
      return
      end
